﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System;
using System.Collections.Generic;
using NSubstitute;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis.Tests
{
    [TestClass()]
    public class RegistrantEmisImporterTests

    {
        RegistrantEmisImporter _cut;
        [TestInitialize()]
        public void MyTestInitialize()
        {
            _cut = new RegistrantEmisImporter();
        }

        [TestMethod()]
        public void CreateRegistrantServiceEpisodeEntryTest()
        {
            MilitaryServiceEpisodeEligibilityData eligibilityData = new MilitaryServiceEpisodeEligibilityData();
            eligibilityData.branchOfServiceCode = "A";
            eligibilityData.serviceEpisodeStartDate = DateTime.Parse("2007-06-26");
            eligibilityData.serviceEpisodeEndDate = DateTime.Parse("2011-01-24");
            eligibilityData.narrativeReasonForSeparationCode = "077";
            REGISTRANT registrant = new REGISTRANT();
            registrant.REGISTRANT_SERVICE_EPISODEs = new EntitySet<REGISTRANT_SERVICE_EPISODE>();

        }

        [TestMethod()]
        public void GetRegistrant_Returns_Correct_Object()
        {
            string edipi = "6001010004";
            string ssn = "555-55-5555";
            DateTime created = DateTime.Parse("2007-06-26");
            DateTime lastUpdated = DateTime.Parse("2011-01-24");
            var registrantManager = Substitute.For<IRegistrantManager>();
            var registrant = new REGISTRANT
            {
                UPDATED = lastUpdated,
                CREATED = created,
                CREATEDBY = "REST Service"
            };
            var updatedRegistrant = new REGISTRANT
            {
                UPDATED = DateTime.Now,
                CREATED = created,
                CREATEDBY = "REST Service"
            };
            registrantManager.GetRegistrantById(edipi, ssn).Returns(registrant);
            registrantManager.InitializeRegistrantDBObject(registrant)
                                            .Returns(updatedRegistrant);
            var actual = RegistrantEmisImporter.InitializeRegistrant(_cut, edipi, ssn, registrantManager);
            Assert.IsNotNull(actual);
            Assert.AreEqual(DateTime.Now.ToString(), actual.UPDATED.ToString(), $"Expected: '{DateTime.Now.ToString()}' != Actual: {actual.UPDATED.ToString()}");
            Assert.AreEqual(created, actual.CREATED, $"Expected: '{created}' != Actual: {actual.CREATED}");
            Assert.AreEqual(registrant.CREATEDBY, actual.CREATEDBY, $"Expected: '{registrant.CREATEDBY}' != Actual: {actual.CREATEDBY}");
        }


    }
}